from __future__ import generators
import plus
import Arenas
import random
import Hazards
import math


class BoxArena(Arenas.SuperArena):
    "The Ring was designed as a circular race track, but with no way to count laps works better as a test course."
    name = "The Ring"
    preview = "lt_testarena/testarena_preview.bmp"
    game_types = ['OBSTACLE COURSE']
    extent = (-45, 25, 45, -25)

    def __init__(self):
        Arenas.SuperArena.__init__(self, "Arenas/lt_testarena/test.gmf")
        #plus.Arena.__init__(self, "")
        plus.setBackColor(0,0,0)
        degrad = 0.01745
        self.AddStaticCamera("Static 1", (10.8, 6.6, -17.04), (.367, -40*degrad), degrad*55)
        self.AddStaticCamera("Static 2", (0, 28.8, 0), (90*degrad, 90*degrad), degrad*37)
        self.AddStaticCamera("Static 3", (0, 7.8, -18), (40*degrad, 0), degrad*62)

	self.AddWatchCamera("Watch Cam 1", (-24, 15, 18), (12, 20, 30*degrad, 20*degrad))
	self.AddWatchCamera("Watch Cam 2", (24, 15, -18), (12, 20, 30*degrad, 20*degrad))
	self.AddWatchCamera("Watch Cam 3", (10, 20, 10), (14, 22, 30*degrad, 30*degrad))
	self.AddWatchCamera("Watch Cam 4", (-10, 20, -10), (16, 24, 30*degrad, 40*degrad))
	
        self.players = ()
	self.robone = 0
	self.robtwo = 0
	self.robtre = 0
	self.robfor = 0
        
    def AddShadowReceivers(self):
        self.SetShadowSource(5.897, 19.159, 5.899)
        
        #Main Arena Floor Shadow Triangles
        self.AddShadowTriangle((-10.2877,0.051,1.83754), (-12.4182,0.051,12.4283), (-12.4182,0.051,1.83754))
        self.AddShadowTriangle((-8.17686,0.051,9.91855), (-8.17686,0.051,12.4283), (-12.4182,0.051,12.4283))
        self.AddShadowTriangle((-8.17686,0.051,9.91855), (-12.4182,0.051,12.4283), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((2.25999,0.051,12.4283), (-2.49123,0.051,12.4283), (-2.49123,0.051,9.91855))
        self.AddShadowTriangle((2.25999,0.051,9.91855), (2.25999,0.051,12.4283), (-2.49123,0.051,9.91855))
        self.AddShadowTriangle((12.413,0.051,12.4283), (7.93297,0.051,12.4283), (7.93297,0.051,9.91855))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (12.413,0.051,12.4283), (7.93297,0.051,9.91855))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (12.413,0.051,1.91641), (12.413,0.051,12.4283))
        self.AddShadowTriangle((8.17711,0.051,-9.92447), (12.413,0.051,-12.4279), (10.2878,0.051,-1.93329))
        self.AddShadowTriangle((10.2878,0.051,-1.93329), (12.413,0.051,-12.4279), (12.413,0.051,-1.93329))
        self.AddShadowTriangle((8.17711,0.051,-9.92447), (8.17711,0.051,-12.4279), (12.413,0.051,-12.4279))
        self.AddShadowTriangle((-2.26871,0.051,-12.4279), (2.49519,0.051,-12.4279), (2.49519,0.051,-9.92447))
        self.AddShadowTriangle((-2.26871,0.051,-9.92447), (-2.26871,0.051,-12.4279), (2.49519,0.051,-9.92447))
        self.AddShadowTriangle((-12.4182,0.051,-12.4279), (-7.93688,0.051,-12.4279), (-7.93688,0.051,-9.92447))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (-12.4182,0.051,-12.4279), (-7.93688,0.051,-9.92447))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (-12.4182,0.051,-1.8361), (-12.4182,0.051,-12.4279))
        self.AddShadowTriangle((-2.49123,0.051,9.91855), (-8.17686,0.051,9.91855), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((2.49519,0.051,-9.92447), (8.17711,0.051,-9.92447), (10.2878,0.051,-1.93329))
        self.AddShadowTriangle((10.2878,0.051,-1.93329), (-10.2877,0.051,-1.8361), (-2.26871,0.051,-9.92447))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (7.93297,0.051,9.91855), (2.25999,0.051,9.91855))
        self.AddShadowTriangle((2.25999,0.051,9.91855), (-2.49123,0.051,9.91855), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (2.25999,0.051,9.91855), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((10.2878,0.051,-1.93329), (10.2878,0.051,1.91641), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (10.2878,0.051,-1.93329), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((-2.26871,0.051,-9.92447), (2.49519,0.051,-9.92447), (10.2878,0.051,-1.93329))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (-7.93688,0.051,-9.92447), (-2.26871,0.051,-9.92447))
        
    def HazardsOn(self, on):
	
	self.RegisterZone("zone1", 1)

	return Arenas.SuperArena.HazardsOn(self, on)

    def Activate(self, on):
        if on: self.players = plus.getPlayers()
        
        Arenas.SuperArena.Activate(self, on)


    def ZoneEvent(self, direction, id, robot, chassis):

        return True

    def Tick(self):
	

        for each in self.players:
            if plus.getLocation(each)[1] < -20:
                plus.eliminatePlayer(each)

        return Arenas.SuperArena.Tick(self)
        
Arenas.register(BoxArena)
